<?php
/* Exit if accessed directly */
	if ( !defined('APP_PATH') ) die("This file cannot be accessed directly.");
	
function myEscape($data) {
    if(is_numeric($data))
        return $data;
    $unpacked = unpack('H*hex', $data);
    return '0x' . $unpacked['hex'];
}
	
/**
 * LEKRDEZSHEZ HASZNLT FGGVNY
 */ 
function myQuery($query, $params=array(), $nullval=true)
{
	global $db;
	
	$stmt = sqlsrv_query($db, $query, $params);
	
	if (!$stmt) {
		echo "ERROR: <br>";
		echo $query . "<br><br>";
		if( ($errors = sqlsrv_errors() ) != null) {
			foreach( $errors as $error ) {
				echo "SQLSTATE: ".$error[ 'SQLSTATE']."<br />";
				echo "code: ".$error[ 'code']."<br />";
				echo "message: ".$error[ 'message']."<br />";
			}
		}
		die();
	}
	
	if (preg_match('#select#', strtolower($query)))
	{
		$return = array();
		while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC))
		$return[] = $row;
	}	
	else
	$return = (bool)$stmt;
	
	if ($stmt)
	{
		if (is_array($return) && !empty($return) )
			return (count($return)>1) ? $return : (!$nullval ? $return : $return[0]);
		else
			return $return;			
	}
	else 
	return false;
}

/**
 * NYELVESITETT ADATOK MEGJELENITSHEZ HASZNLT FGGVNY
 */ 
function lang($expression) {
	$lang_array = parse_ini_file("lang_" . LANG . ".ini");
	if(isset($lang_array[$expression])) {
		return $lang_array[$expression];
	}
	else {
		return $expression;
	}
}

/**
 * HIBAKERESST SEGT FGGVNY
 */ 
function dump($be, $text = '',  $out = true ) 
{ 
	echo '<pre>'; 
		echo $text . ": <br>";
		if ( $out ) {
			print_r($be);
		} else {
			var_dump($be); 
		}		
	echo '</pre>'; 
}

function redirect($url) {
	header('location:' . $url);
}